/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.CastSpellLastTurnWatcher;

class CurseOfExhaustionEffect
extends ContinuousRuleModifyingEffectImpl {
    CurseOfExhaustionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Enchanted player can't cast more than one spell each turn";
    }

    private CurseOfExhaustionEffect(CurseOfExhaustionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CurseOfExhaustionEffect copy() {
        return new CurseOfExhaustionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (player = game.getPlayer(enchantment.getAttachedTo())) != null && event.getPlayerId().equals(player.getId())) {
            CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
            return watcher != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(event.getPlayerId()) > 0;
        }
        return false;
    }
}

