/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GoldToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfOpulenceEffect
extends OneShotEffect {
    CurseOfOpulenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a Gold token. Each opponent attacking that player does the same.";
    }

    private CurseOfOpulenceEffect(CurseOfOpulenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfOpulenceEffect copy() {
        return new CurseOfOpulenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Player enchantedPlayer = game.getPlayer(enchantment.getAttachedTo());
        if (enchantedPlayer == null) {
            return false;
        }
        HashSet<UUID> players = new HashSet<UUID>();
        for (UUID attacker : game.getCombat().getAttackers()) {
            UUID defender = game.getCombat().getDefenderId(attacker);
            if (!defender.equals(enchantedPlayer.getId()) || !game.getPlayer(source.getControllerId()).hasOpponent(game.getPermanent(attacker).getControllerId(), game)) continue;
            players.add(game.getPermanent(attacker).getControllerId());
        }
        players.add(source.getControllerId());
        for (UUID player : players) {
            game.getPlayer(player);
            CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new GoldToken());
            effect.setTargetPointer((TargetPointer)new FixedTarget(player));
            effect.apply(game, source);
        }
        return true;
    }
}

