/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfShallowEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfShallowTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfShallowTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfShallowEffect());
    }

    public CurseOfShallowTriggeredAbility(Effect effect, boolean optional, String text) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private CurseOfShallowTriggeredAbility(CurseOfShallowTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && game.getCombat().getPlayerDefenders(game, false).contains(enchantment.getAttachedTo())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getAttackingPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player attacks enchanted player with one or more creatures, that attacking player may create a tapped 2/2 black Zombie creature token.";
    }

    public CurseOfShallowTriggeredAbility copy() {
        return new CurseOfShallowTriggeredAbility(this);
    }
}

