/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfStalkedPreyTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfStalkedPreyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
    }

    private CurseOfStalkedPreyTriggeredAbility(CurseOfStalkedPreyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CurseOfStalkedPreyTriggeredAbility copy() {
        return new CurseOfStalkedPreyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        Permanent enchantment;
        if (((DamagedPlayerEvent)event).isCombatDamage() && (enchantment = game.getPermanent(this.sourceId)) != null && enchantment.getAttachedTo() != null && (player = game.getPlayer(enchantment.getAttachedTo())) != null && event.getTargetId().equals(player.getId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature deals combat damage to enchanted player, put a +1/+1 counter on that creature.";
    }
}

