/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class CursedRackHandSizeEffect
extends ContinuousEffectImpl {
    CursedRackHandSizeEffect() {
        super(Duration.WhileOnBattlefield, Layer.PlayerEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = "The chosen player's maximum hand size is four";
    }

    private CursedRackHandSizeEffect(CursedRackHandSizeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CursedRackHandSizeEffect copy() {
        return new CursedRackHandSizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID playerId = (UUID)game.getState().getValue(source.getSourceId() + "_opponent");
        Player opponent = game.getPlayer(playerId);
        if (opponent != null) {
            opponent.setMaxHandSize(4);
            return true;
        }
        return false;
    }
}

