/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class CustodiSoulcallerWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playersAttacked = new HashMap<UUID, Set<UUID>>(0);

    CustodiSoulcallerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGIN_COMBAT_STEP_PRE) {
            this.playersAttacked.clear();
        } else if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            Set attackedPlayers = this.playersAttacked.getOrDefault(event.getPlayerId(), new HashSet(1));
            attackedPlayers.add(event.getTargetId());
            this.playersAttacked.put(event.getPlayerId(), attackedPlayers);
        }
    }

    public int getNumberOfAttackedPlayers(UUID attackerId) {
        return this.playersAttacked.get(attackerId).size();
    }
}

