/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.choices.VoteHandler;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class CustodiSquireVote
extends VoteHandler<Card> {
    private static final FilterCard filter = new FilterCard("artifact, creature, or enchantment card");

    CustodiSquireVote() {
    }

    protected Set<Card> getPossibleVotes(Ability source, Game game) {
        return new LinkedHashSet<Card>();
    }

    public Card playerChoose(String voteInfo, Player player, Player decidingPlayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || controller.getGraveyard().count(filter, source.getControllerId(), source, game) < 1) {
            return null;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        target.withChooseHint(voteInfo + " (from graveyard to hand)");
        target.withNotTarget(true);
        decidingPlayer.choose(Outcome.ReturnToHand, (Cards)controller.getGraveyard(), (TargetCard)target, source, game);
        return controller.getGraveyard().get(target.getFirstTarget(), game);
    }

    protected String voteName(Card vote) {
        return vote.getIdName();
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate()}));
    }
}

