/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CutADealEffect
extends OneShotEffect {
    CutADealEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent draws a card, then you draw a card for each opponent who drew a card this way";
    }

    private CutADealEffect(CutADealEffect effect) {
        super((OneShotEffect)effect);
    }

    public CutADealEffect copy() {
        return new CutADealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(player -> player.drawCards(1, source, game)).sum();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && count > 0) {
            controller.drawCards(count, source, game);
            return true;
        }
        return false;
    }
}

