/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CutPropulsionEffect
extends OneShotEffect {
    CutPropulsionEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature deals damage to itself equal to its power. If that creature has flying, it deals twice that much damage to itself instead";
    }

    private CutPropulsionEffect(CutPropulsionEffect effect) {
        super((OneShotEffect)effect);
    }

    public CutPropulsionEffect copy() {
        return new CutPropulsionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int damage = (permanent.getAbilities(game).containsClass(FlyingAbility.class) ? 2 : 1) * permanent.getPower().getValue();
        return damage > 0 && permanent.damage(damage, permanent.getId(), source, game) > 0;
    }
}

