/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class CyclopeanTombCounterWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> counterData = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    CyclopeanTombCounterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent tomb;
        if (event.getType() == GameEvent.EventType.COUNTERS_ADDED && event.getData().equals(CounterType.MIRE.getName()) && event.getAmount() > 0 && (tomb = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null) {
            Set<Object> miredLands;
            MageObjectReference cylopeanTombInstance = new MageObjectReference((MageObject)tomb, game);
            if (this.counterData.containsKey(cylopeanTombInstance)) {
                miredLands = this.counterData.get(cylopeanTombInstance);
            } else {
                miredLands = new HashSet();
                this.counterData.put(cylopeanTombInstance, miredLands);
            }
            miredLands.add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    public Set<MageObjectReference> landMiredByCyclopeanTombInstance(MageObjectReference mor, Game game) {
        if (this.counterData.containsKey(mor)) {
            return this.counterData.get(mor);
        }
        return null;
    }
}

