/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KillerEffect
extends OneShotEffect {
    KillerEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature and each other creature that shares a creature type with it";
    }

    private KillerEffect(KillerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            target.damage(3, source, game);
            for (Permanent p : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                if (target.getId().equals(p.getId()) || !p.shareCreatureTypes(game, (MageObject)target)) continue;
                p.damage(3, source, game);
            }
            return true;
        }
        return false;
    }

    public KillerEffect copy() {
        return new KillerEffect(this);
    }
}

