/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class PunishmentEffect
extends OneShotEffect {
    PunishmentEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each artifact, creature, and enchantment with mana value X";
    }

    private PunishmentEffect(PunishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public PunishmentEffect copy() {
        return new PunishmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent == null || permanent.getManaValue() != ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue() || !permanent.isArtifact(game) && !permanent.isCreature(game) && !permanent.isEnchantment(game)) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

