/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.c.TheOmenkeelPlayFromExileEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TheOmenkeelEffect
extends OneShotEffect {
    TheOmenkeelEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player exiles that many cards from the top of their library. You may play lands from among those cards for as long as they remain exiled.";
    }

    private TheOmenkeelEffect(TheOmenkeelEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheOmenkeelEffect copy() {
        return new TheOmenkeelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int damage = (Integer)this.getValue("damage");
        if (player == null || damage < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, damage));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.EXILED);
        cards.removeIf(uuid -> !game.getCard(uuid).isLand(game));
        game.addEffect((ContinuousEffect)new TheOmenkeelPlayFromExileEffect((Cards)cards, game), source);
        return true;
    }
}

