/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BoostCreatureEffectEffect
extends ContinuousEffectImpl {
    BoostCreatureEffectEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Creatures you control of the chosen type get +1/+1 for each charge counter on {this}";
    }

    private BoostCreatureEffectEffect(BoostCreatureEffectEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BoostCreatureEffectEffect copy() {
        return new BoostCreatureEffectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SubType subtype;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (subtype = (SubType)game.getState().getValue(permanent.getId() + "_type")) != null) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game)) {
                if (!perm.hasSubtype(subtype, game)) continue;
                int boost = permanent.getCounters(game).getCount(CounterType.CHARGE);
                perm.addPower(boost);
                perm.addToughness(boost);
            }
        }
        return true;
    }
}

