/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CardsInEnchantedCreaturesControllerGraveyardCount
implements DynamicValue {
    private final FilterCard filter;

    CardsInEnchantedCreaturesControllerGraveyardCount(FilterCard filter) {
        this.filter = filter;
    }

    private CardsInEnchantedCreaturesControllerGraveyardCount(CardsInEnchantedCreaturesControllerGraveyardCount dynamicValue) {
        this.filter = dynamicValue.filter;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player;
        Permanent creature;
        Permanent attachment = game.getPermanent(sourceAbility.getSourceId());
        if (attachment != null && (creature = game.getPermanent(attachment.getAttachedTo())) != null && (player = game.getPlayer(creature.getControllerId())) != null) {
            return player.getGraveyard().count(this.filter, game);
        }
        return 0;
    }

    public CardsInEnchantedCreaturesControllerGraveyardCount copy() {
        return new CardsInEnchantedCreaturesControllerGraveyardCount(this);
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return this.filter.getMessage();
    }
}

