/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DanceOfManyCreateTokenCopyEffect
extends OneShotEffect {
    DanceOfManyCreateTokenCopyEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of target nontoken creature";
    }

    private DanceOfManyCreateTokenCopyEffect(DanceOfManyCreateTokenCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (permanent != null && sourceObject != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            game.getState().setValue(source.getSourceId() + "_token", (Object)effect.getAddedPermanents());
            for (Permanent addedToken : effect.getAddedPermanents()) {
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice Dance of Many");
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(sourceObject, game));
                LeavesBattlefieldTriggeredAbility triggerAbility = new LeavesBattlefieldTriggeredAbility((Effect)sacrificeEffect, false);
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)triggerAbility, Duration.WhileOnBattlefield);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken, game));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            }
            return true;
        }
        return false;
    }

    public DanceOfManyCreateTokenCopyEffect copy() {
        return new DanceOfManyCreateTokenCopyEffect(this);
    }
}

