/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AddCardSubtypeAttachedEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.JobSelectAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;

public final class DancersChakrams
extends CardImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("commanders you control");
    private static final FilterControlledPermanent filter2 = new FilterControlledPermanent("commanders you control");

    public DancersChakrams(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}{W}");
        this.subtype.add((Object)SubType.EQUIPMENT);
        this.addAbility((Ability)new JobSelectAbility());
        SimpleStaticAbility commanderAbility = new SimpleStaticAbility((Effect)new BoostAllEffect(2, 2, Duration.WhileOnBattlefield, filter, true));
        commanderAbility.addEffect((Effect)new GainAbilityControlledEffect((Ability)LifelinkAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)filter2).setText("and have lifelink"));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEquippedEffect(2, 2));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)LifelinkAbility.getInstance(), AttachmentType.EQUIPMENT).setText(", has lifelink"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)commanderAbility, AttachmentType.EQUIPMENT).setText("and \"Other commanders you control get +2/+2 and have lifelink,\""));
        ability.addEffect((Effect)new AddCardSubtypeAttachedEffect(SubType.PERFORMER, AttachmentType.EQUIPMENT).setText("and is a Performer in addition to its other types"));
        this.addAbility((Ability)ability);
        this.addAbility(new EquipAbility(3).withFlavorWord("Krishna"));
    }

    private DancersChakrams(DancersChakrams card) {
        super((CardImpl)card);
    }

    public DancersChakrams copy() {
        return new DancersChakrams(this);
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
        filter2.add((Predicate)CommanderPredicate.instance);
    }
}

