/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;
import mage.watchers.common.CountersAddedFirstTimeWatcher;

class DannyPinkTriggeredAbility
extends TriggeredAbilityImpl {
    DannyPinkTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
        this.setTriggerPhrase("Whenever one or more counters are put on this creature for the first time each turn, ");
        this.addWatcher((Watcher)new CountersAddedFirstTimeWatcher());
    }

    private DannyPinkTriggeredAbility(DannyPinkTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED || event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.getSourceId().equals(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            Counters counters = permanent.getCounters(game);
            return !counters.values().stream().mapToInt(Counter::getCount).noneMatch(x -> x > 0) && !(permanent instanceof PermanentToken);
        }
        if (event.getType() == GameEvent.EventType.COUNTERS_ADDED) {
            return CountersAddedFirstTimeWatcher.checkEvent((GameEvent)event, (Permanent)permanent, (Game)game, (int)0);
        }
        return false;
    }

    public DannyPinkTriggeredAbility copy() {
        return new DannyPinkTriggeredAbility(this);
    }
}

