/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DarettiSacrificeEffect
extends OneShotEffect {
    DarettiSacrificeEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Sacrifice an artifact. If you do, return target artifact card from your graveyard to the battlefield";
    }

    private DarettiSacrificeEffect(DarettiSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarettiSacrificeEffect copy() {
        return new DarettiSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledArtifactPermanent(), true);
        if (!target.canChoose(controller.getId(), source, game) || !controller.chooseTarget(this.outcome, (Target)target, source, game)) {
            return true;
        }
        Permanent artifact = game.getPermanent(target.getFirstTarget());
        if (artifact == null || !artifact.sacrifice(source, game)) {
            return true;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        return card == null || controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

