/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class DarkImpostorContinuousEffect
extends ContinuousEffectImpl {
    DarkImpostorContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all creature cards exiled with it";
    }

    private DarkImpostorContinuousEffect(DarkImpostorContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source, (int)1));
        if (permanent == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        for (Card card : exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isActivatedAbility()) continue;
                permanent.addAbility(ability, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    public DarkImpostorContinuousEffect copy() {
        return new DarkImpostorContinuousEffect(this);
    }
}

