/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DarkRevenantEffect
extends OneShotEffect {
    DarkRevenantEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "put it on top of its owner's library";
    }

    private DarkRevenantEffect(DarkRevenantEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkRevenantEffect copy() {
        return new DarkRevenantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Card card = game.getCard(source.getSourceId());
        if (card != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (controller = game.getPlayer(source.getControllerId())) != null) {
            return controller.putCardsOnTopOfLibrary(card, game, source, true);
        }
        return true;
    }
}

