/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class DashHopesCounterSourceEffect
extends OneShotEffect {
    DashHopesCounterSourceEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "any player may pay 5 life. If a player does, counter {this}";
    }

    private DashHopesCounterSourceEffect(DashHopesCounterSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public DashHopesCounterSourceEffect copy() {
        return new DashHopesCounterSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            PayLifeCost cost = new PayLifeCost(5);
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                cost.clearPaid();
                if (!cost.canPay(source, source, player.getId(), game) || !player.chooseUse(this.outcome, "Pay 5 life to counter " + sourceObject.getIdName() + '?', source, game) || !cost.pay(source, game, source, player.getId(), false, null)) continue;
                game.informPlayers(player.getLogName() + " pays 5 life to counter " + sourceObject.getIdName() + '.');
                Spell spell = game.getStack().getSpell(source.getSourceId());
                if (spell == null) continue;
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

