/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class DaughterOfAutumnPreventDamageTargetEffect
extends RedirectionEffect {
    private static FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public DaughterOfAutumnPreventDamageTargetEffect(Duration duration, int amount) {
        super(duration, amount, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next " + amount + " damage that would be dealt to target white creature this turn is dealt to {this} instead";
    }

    private DaughterOfAutumnPreventDamageTargetEffect(DaughterOfAutumnPreventDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
    }

    public DaughterOfAutumnPreventDamageTargetEffect copy() {
        return new DaughterOfAutumnPreventDamageTargetEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && filter.match(permanent, permanent.getControllerId(), source, game) && event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && event.getTargetId() != null) {
            TargetPermanent target = new TargetPermanent();
            target.add(source.getSourceId(), game);
            this.redirectTarget = target;
            return true;
        }
        return false;
    }
}

