/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class DauntlessDismantlerEffect
extends OneShotEffect {
    DauntlessDismantlerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy each artifact with mana value X";
    }

    private DauntlessDismantlerEffect(DauntlessDismantlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DauntlessDismantlerEffect copy() {
        return new DauntlessDismantlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterArtifactPermanent filter = new FilterArtifactPermanent();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        boolean destroyed = false;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            destroyed |= permanent.destroy(source, game);
        }
        return destroyed;
    }
}

