/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class DawnEvangelAbility
extends DiesCreatureTriggeredAbility {
    private static final FilterCard cardFilter = new FilterCreatureCard("creature card with mana value 2 or less from your graveyard");

    DawnEvangelAbility() {
        super((Effect)new ReturnFromGraveyardToHandTargetEffect(), false);
        this.addTarget((Target)new TargetCardInYourGraveyard(cardFilter));
    }

    private DawnEvangelAbility(DawnEvangelAbility ability) {
        super((DiesCreatureTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getTarget().getAttachments().stream().map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.hasSubtype(SubType.AURA, game)).map(Controllable::getControllerId).anyMatch(this.getControllerId()::equals);
    }

    public String getRule() {
        return "Whenever a creature dies, if an Aura you controlled was attached to it, return target creature card with mana value 2 or less from your graveyard to your hand.";
    }

    public DawnEvangelAbility copy() {
        return new DawnEvangelAbility(this);
    }

    static {
        cardFilter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

