/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.d.DeadMansChestSpendManaEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DeadMansChestEffect
extends OneShotEffect {
    DeadMansChestEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards equal to its power from the top of its owner's library. You may cast spells from among those cards for as long as they remain exiled, and you may spend mana as though it were mana of any type to cast those spells";
    }

    private DeadMansChestEffect(DeadMansChestEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadMansChestEffect copy() {
        return new DeadMansChestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Permanent attachedTo = (Permanent)this.getValue("attachedTo");
        if (controller != null && sourceObject != null && attachedTo != null) {
            Set cards;
            Player owner = game.getPlayer(attachedTo.getOwnerId());
            int amount = attachedTo.getPower().getValue();
            if (owner != null && amount > 0 && !(cards = owner.getLibrary().getTopCards(game, amount)).isEmpty()) {
                controller.moveCardsToExile(cards, source, game, true, source.getSourceId(), sourceObject.getName());
                for (Card card : cards) {
                    if (card.isLand(game)) continue;
                    Object effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.Custom);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                    game.addEffect((ContinuousEffect)effect, source);
                    effect = new DeadMansChestSpendManaEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

