/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DeadlyTempestEffect
extends OneShotEffect {
    DeadlyTempestEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures. Each player loses life equal to the number of creatures they controlled that were destroyed this way";
    }

    private DeadlyTempestEffect(DeadlyTempestEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadlyTempestEffect copy() {
        return new DeadlyTempestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int count;
            HashMap<UUID, Integer> destroyedCreatures = new HashMap<UUID, Integer>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (!permanent.destroy(source, game, false)) continue;
                count = destroyedCreatures.getOrDefault(permanent.getControllerId(), 0);
                destroyedCreatures.put(permanent.getControllerId(), count + 1);
            }
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                Player player;
                count = destroyedCreatures.getOrDefault(playerId, 0);
                if (count <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.loseLife(count, game, source, false);
            }
            return true;
        }
        return false;
    }
}

