/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsControllerEffect;
import mage.cards.d.DeathsOasisEffect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class DeathsOasisTriggeredAbility
extends DiesCreatureTriggeredAbility {
    DeathsOasisTriggeredAbility() {
        super(null, false, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN, false);
    }

    private DeathsOasisTriggeredAbility(DeathsOasisTriggeredAbility ability) {
        super((DiesCreatureTriggeredAbility)ability);
    }

    public DeathsOasisTriggeredAbility copy() {
        return new DeathsOasisTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTarget() == null) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new MillCardsControllerEffect(2));
        this.addEffect((Effect)new DeathsOasisEffect(zEvent.getTarget().getManaValue()));
        return true;
    }

    public String getRule() {
        return "Whenever a nontoken creature you control dies, mill two cards. Then return a creature card with lesser mana value than the creature that died from your graveyard to your hand.";
    }
}

