/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DebtOfLoyaltyEffect
extends RegenerateTargetEffect {
    DebtOfLoyaltyEffect() {
        this.staticText = "Regenerate target creature. You gain control of that creature if it regenerates this way.";
    }

    private DebtOfLoyaltyEffect(DebtOfLoyaltyEffect effect) {
        super((RegenerateTargetEffect)effect);
    }

    public DebtOfLoyaltyEffect copy() {
        return new DebtOfLoyaltyEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (super.replaceEvent(event, source, game) && permanent != null) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame);
            effect.setTargetPointer(this.getTargetPointer().copy());
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

