/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class DebtToTheKamiExileCreatureEffect
extends OneShotEffect {
    DebtToTheKamiExileCreatureEffect() {
        super(Outcome.Exile);
        this.staticText = "Target opponent exiles a creature they control";
    }

    private DebtToTheKamiExileCreatureEffect(DebtToTheKamiExileCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public DebtToTheKamiExileCreatureEffect copy() {
        return new DebtToTheKamiExileCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

