/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;

class DeceiverOfFormEffect
extends OneShotEffect {
    DeceiverOfFormEffect() {
        super(Outcome.Copy);
        this.staticText = "reveal the top card of your library. If a creature card is revealed this way, you may have creatures you control other than {this} become copies of that card until end of turn. You may put that card on the bottom of your library";
    }

    private DeceiverOfFormEffect(DeceiverOfFormEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeceiverOfFormEffect copy() {
        return new DeceiverOfFormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card copyFromCard = null;
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card cardFromTop = controller.getLibrary().getFromTop(game);
            if (cardFromTop != null) {
                CardsImpl cards = new CardsImpl(cardFromTop);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (cardFromTop.isCreature(game)) {
                    copyFromCard = cardFromTop;
                    if (controller.chooseUse(this.outcome, "Let creatures you control other than " + sourceObject.getLogName() + " becomes copies of " + cardFromTop.getLogName() + " until end of turn?", source, game)) {
                        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
                            if (permanent.getId().equals(sourceObject.getId())) continue;
                            if (cardFromTop instanceof ModalDoubleFacedCard && ((ModalDoubleFacedCard)cardFromTop).getLeftHalfCard().isCreature(game)) {
                                copyFromCard = ((ModalDoubleFacedCard)cardFromTop).getLeftHalfCard();
                            }
                            PermanentCard newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
                            CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)newBluePrint, permanent.getId());
                            Ability newAbility = source.copy();
                            copyEffect.init(newAbility, game);
                            game.addEffect((ContinuousEffect)copyEffect, newAbility);
                        }
                    }
                }
                if (controller.chooseUse(this.outcome, "Move " + cardFromTop.getLogName() + " to the bottom of your library?", source, game)) {
                    controller.moveCardToLibraryWithInfo(cardFromTop, source, game, Zone.LIBRARY, false, true);
                }
            }
            return true;
        }
        return false;
    }
}

