/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SoldierToken;
import mage.players.Player;
import mage.util.ManaUtil;

class DecreeOfJusticeCycleEffect
extends OneShotEffect {
    DecreeOfJusticeCycleEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. If you do, create X 1/1 white Soldier creature tokens";
    }

    private DecreeOfJusticeCycleEffect(DecreeOfJusticeCycleEffect effect) {
        super((OneShotEffect)effect);
    }

    public DecreeOfJusticeCycleEffect copy() {
        return new DecreeOfJusticeCycleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.chooseUse(Outcome.Benefit, "Pay {X} to create X tokens?", source, game)) {
            return false;
        }
        int payCount = ManaUtil.playerPaysXGenericMana((boolean)true, (String)"Decree of Justice", (Player)player, (Ability)source, (Game)game);
        if (payCount > 0) {
            return new SoldierToken().putOntoBattlefield(payCount, game, source, source.getControllerId());
        }
        return false;
    }
}

