/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DecreeOfPainEffect
extends OneShotEffect {
    DecreeOfPainEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures. They can't be regenerated. Draw a card for each creature destroyed this way";
    }

    private DecreeOfPainEffect(DecreeOfPainEffect effect) {
        super((OneShotEffect)effect);
    }

    public DecreeOfPainEffect copy() {
        return new DecreeOfPainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedCreature = 0;
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
                if (!creature.destroy(source, game, true)) continue;
                ++destroyedCreature;
            }
            if (destroyedCreature > 0) {
                game.processAction();
                controller.drawCards(destroyedCreature, source, game);
            }
            return true;
        }
        return false;
    }
}

