/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DeepWoodEffect
extends PreventionEffectImpl {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature();

    DeepWoodEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by attacking creatures";
    }

    private DeepWoodEffect(DeepWoodEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public DeepWoodEffect copy() {
        return new DeepWoodEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamagePlayerEvent && event.getAmount() > 0) {
            Permanent permanent;
            DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
            if (event.getTargetId().equals(source.getControllerId()) && filter.match((Object)(permanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId())), game)) {
                return true;
            }
        }
        return false;
    }
}

