/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class DeepfathomEchoEffect
extends OneShotEffect {
    DeepfathomEchoEffect() {
        super(Outcome.Copy);
        this.staticText = "Then you may have it become a copy of another creature you control until end of turn";
    }

    private DeepfathomEchoEffect(DeepfathomEchoEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeepfathomEchoEffect copy() {
        return new DeepfathomEchoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent deepfathom = source.getSourcePermanentIfItStillExists(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (deepfathom == null || controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Permanent chosenCreature = game.getPermanent(target.getFirstTarget());
        if (chosenCreature == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, chosenCreature, deepfathom.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

