/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class DeepglowSkateEffect
extends OneShotEffect {
    DeepglowSkateEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on any number of target permanents";
    }

    private DeepglowSkateEffect(DeepglowSkateEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeepglowSkateEffect copy() {
        return new DeepglowSkateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean didOne = false;
        for (Target target : source.getTargets()) {
            for (UUID targetID : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetID);
                if (permanent == null) continue;
                for (Counter counter : permanent.getCounters(game).values()) {
                    Counter newCounter = new Counter(counter.getName(), counter.getCount());
                    permanent.addCounters(newCounter, source.getControllerId(), source, game);
                    didOne = true;
                }
            }
        }
        return didOne;
    }
}

