/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class DefenseGridCostModificationEffect
extends CostModificationEffectImpl {
    DefenseGridCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Each spell costs {3} more to cast except during its controller's turn";
    }

    private DefenseGridCostModificationEffect(DefenseGridCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        spellAbility.addManaCostsToPay((ManaCost)new GenericManaCost(3));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && !abilityToModify.isControlledBy(game.getActivePlayerId());
    }

    public DefenseGridCostModificationEffect copy() {
        return new DefenseGridCostModificationEffect(this);
    }
}

