/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ExploreSourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DefossilizeEffect
extends OneShotEffect {
    DefossilizeEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield. That creature explores, then it explores again";
    }

    private DefossilizeEffect(DefossilizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DefossilizeEffect copy() {
        return new DefossilizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        game.processAction();
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        ExploreSourceEffect.explorePermanent((Game)game, (UUID)permanent.getId(), (Ability)source, (int)2);
        return true;
    }
}

