/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ChoosePlaneswalkerTypeEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RemoveCountersEvent;
import mage.game.permanent.Permanent;

class DeificationReplacementEffect
extends ReplacementEffectImpl {
    DeificationReplacementEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "As long as you control a creature, if damage dealt to a planeswalker you control of the chosen type would result in all loyalty counters on it being removed, instead all but one of those counters are removed.";
    }

    private DeificationReplacementEffect(DeificationReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DeificationReplacementEffect copy() {
        return new DeificationReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REMOVE_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        RemoveCountersEvent rEvent = (RemoveCountersEvent)event;
        Permanent planeswalker = game.getPermanent(rEvent.getTargetId());
        if (planeswalker == null) {
            return false;
        }
        if (!source.isControlledBy(planeswalker.getControllerId()) || 0 == game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, planeswalker.getControllerId(), source, game)) {
            return false;
        }
        if (!planeswalker.hasSubtype(ChoosePlaneswalkerTypeEffect.getChosenPlaneswalkerType((UUID)source.getSourceId(), (Game)game), game)) {
            return false;
        }
        if (!rEvent.counterRemovedDueToDamage()) {
            return false;
        }
        int loyaltyCounters = planeswalker.getCounters(game).getCount(CounterType.LOYALTY);
        return loyaltyCounters - event.getAmount() < 1;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent planeswalker = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (planeswalker == null) {
            return false;
        }
        int loyaltyCounters = planeswalker.getCounters(game).getCount(CounterType.LOYALTY);
        event.setAmount(loyaltyCounters - 1);
        return false;
    }
}

