/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class DelayEffect
extends OneShotEffect {
    DelayEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. If the spell is countered this way, exile it with three time counters on it instead of putting it into its owner's graveyard. If it doesn't have suspend, it gains suspend";
    }

    private DelayEffect(DelayEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelayEffect copy() {
        return new DelayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        return controller != null && spell != null && game.getStack().counter(spell.getId(), source, game, PutCards.EXILED) && SuspendAbility.addTimeCountersAndSuspend((Card)spell.getMainCard(), (int)3, (Ability)source, (Game)game);
    }
}

