/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DemonicEmbracePlayEffect
extends AsThoughEffectImpl {
    DemonicEmbracePlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard by paying 3 life and discarding a card in addition to paying its other costs";
    }

    private DemonicEmbracePlayEffect(DemonicEmbracePlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public DemonicEmbracePlayEffect copy() {
        return new DemonicEmbracePlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player player;
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (player = game.getPlayer(affectedControllerId)) != null) {
            CostsImpl costs = new CostsImpl();
            costs.add((Object)new PayLifeCost(3));
            costs.add((Object)new DiscardCardCost());
            player.setCastSourceIdWithAlternateMana(sourceId, (ManaCosts)new ManaCostsImpl("{1}{B}{B}"), (Costs)costs, MageIdentifier.DemonicEmbraceAlternateCast);
            return true;
        }
        return false;
    }
}

