/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;

class DemonicHordesEffect
extends OneShotEffect {
    protected Cost cost;

    public DemonicHordesEffect(Cost cost) {
        super(Outcome.Sacrifice);
        this.cost = cost;
        this.staticText = "unless you pay {B}{B}{B}, tap {this} and sacrifice a land of an opponent's choice";
    }

    private DemonicHordesEffect(DemonicHordesEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent demonicHordes = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && demonicHordes != null) {
            StringBuilder sb = new StringBuilder(this.cost.getText()).append('?');
            if (!sb.toString().toLowerCase(Locale.ENGLISH).startsWith("exile ") && !sb.toString().toLowerCase(Locale.ENGLISH).startsWith("return ")) {
                sb.insert(0, "Pay ");
            }
            if (controller.chooseUse(Outcome.Benefit, sb.toString(), source, game)) {
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            demonicHordes.tap(source, game);
            TargetOpponent choiceOpponent = new TargetOpponent();
            choiceOpponent.withNotTarget(true);
            FilterLandPermanent filterLand = new FilterLandPermanent();
            filterLand.add((Predicate)new ControllerIdPredicate(source.getControllerId()));
            if (controller.choose(Outcome.Neutral, (Target)choiceOpponent, source, game)) {
                Player opponent = game.getPlayer(choiceOpponent.getFirstTarget());
                if (opponent != null) {
                    Permanent land;
                    TargetPermanent chosenLand = new TargetPermanent((FilterPermanent)filterLand);
                    chosenLand.withNotTarget(true);
                    if (opponent.chooseTarget(Outcome.Sacrifice, (Target)chosenLand, source, game) && (land = game.getPermanent(chosenLand.getFirstTarget())) != null) {
                        land.sacrifice(source, game);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public DemonicHordesEffect copy() {
        return new DemonicHordesEffect(this);
    }
}

