/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DereviEmpyrialTacticianTriggeredAbility
extends TriggeredAbilityImpl {
    public DereviEmpyrialTacticianTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
    }

    private DereviEmpyrialTacticianTriggeredAbility(DereviEmpyrialTacticianTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanent(event.getSourceId())) != null && creature.isControlledBy(this.controllerId);
    }

    public String getRule() {
        return "Whenever {this} enters or a creature you control deals combat damage to a player, you may tap or untap target permanent.";
    }

    public DereviEmpyrialTacticianTriggeredAbility copy() {
        return new DereviEmpyrialTacticianTriggeredAbility(this);
    }
}

