/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DescendantOfMasumaroEffect
extends OneShotEffect {
    DescendantOfMasumaroEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on {this} for each card in your hand, then remove a +1/+1 counter from {this} for each card in target opponent's hand";
    }

    private DescendantOfMasumaroEffect(DescendantOfMasumaroEffect effect) {
        super((OneShotEffect)effect);
    }

    public DescendantOfMasumaroEffect copy() {
        return new DescendantOfMasumaroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            Player targetOpponent;
            if (!controller.getHand().isEmpty()) {
                new AddCountersSourceEffect(CounterType.P1P1.createInstance(controller.getHand().size()), true).apply(game, source);
            }
            if ((targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null && !targetOpponent.getHand().isEmpty()) {
                sourcePermanent.removeCounters(CounterType.P1P1.getName(), targetOpponent.getHand().size(), source, game);
                game.informPlayers(controller.getLogName() + " removes " + targetOpponent.getHand().size() + " +1/+1 counters from " + sourcePermanent.getLogName());
            }
            return true;
        }
        return false;
    }
}

