/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DescendantsFuryEffect
extends OneShotEffect {
    DescendantsFuryEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal cards from the top of your library until you reveal a creature card that shares a creature type with the sacrificed creature. Put that card onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private DescendantsFuryEffect(DescendantsFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public DescendantsFuryEffect copy() {
        return new DescendantsFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("SACRIFICED_PERMANENT");
        if (permanent == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl revealed = new CardsImpl();
        CardsImpl otherCards = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            revealed.add(card);
            if (card != null && card.isCreature(game) && permanent.shareCreatureTypes(game, (MageObject)card)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                break;
            }
            otherCards.add(card);
        }
        controller.revealCards(source, (Cards)revealed, game);
        controller.putCardsOnBottomOfLibrary((Cards)otherCards, game, source, false);
        return true;
    }
}

