/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DesecratorHagEffect
extends OneShotEffect {
    int creatureGreatestPower = 0;
    Cards cards = new CardsImpl();
    TargetCard target = new TargetCard(Zone.GRAVEYARD, new FilterCard());

    public DesecratorHagEffect() {
        super(Outcome.DrawCard);
        this.staticText = "return to your hand the creature card in your graveyard with the greatest power. If two or more cards are tied for greatest power, you choose one of them";
    }

    private DesecratorHagEffect(DesecratorHagEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesecratorHagEffect copy() {
        return new DesecratorHagEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you != null) {
            for (Card card : you.getGraveyard().getCards(game)) {
                if (!card.isCreature(game)) continue;
                if (card.getPower().getValue() > this.creatureGreatestPower) {
                    this.creatureGreatestPower = card.getPower().getValue();
                    this.cards.clear();
                    this.cards.add(card);
                    continue;
                }
                if (card.getPower().getValue() != this.creatureGreatestPower) continue;
                this.cards.add(card);
            }
            if (this.cards.isEmpty()) {
                return true;
            }
            if (this.cards.size() > 1 && you.choose(Outcome.DrawCard, this.cards, this.target, source, game)) {
                Card card;
                if (this.target != null && (card = game.getCard(this.target.getFirstTarget())) != null) {
                    return you.moveCards(card, Zone.HAND, source, game);
                }
            } else {
                return you.moveCards(this.cards, Zone.HAND, source, game);
            }
        }
        return false;
    }
}

