/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.d.DesolationWatcher;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class DesolationEffect
extends OneShotEffect {
    DesolationEffect() {
        super(Outcome.Damage);
        this.staticText = "each player who tapped a land for mana this turn sacrifices a land. {this} deals 2 damage to each player who sacrificed a Plains this way";
    }

    private DesolationEffect(DesolationEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        DesolationWatcher watcher = (DesolationWatcher)game.getState().getWatcher(DesolationWatcher.class);
        if (watcher == null) {
            return false;
        }
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        for (UUID playerId : watcher.getPlayersTappedForMana()) {
            TargetSacrifice target;
            player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND)).canChoose(player.getId(), source, game)) continue;
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanents.add(permanent);
        }
        for (Permanent permanent : permanents) {
            player = game.getPlayer(permanent.getControllerId());
            if (!permanent.sacrifice(source, game) || !permanent.hasSubtype(SubType.PLAINS, game) || player == null) continue;
            player.damage(2, source.getSourceId(), source, game);
        }
        return true;
    }

    public DesolationEffect copy() {
        return new DesolationEffect(this);
    }
}

