/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.d.DestinySpinnerCount;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class DestinySpinnerEffect
extends OneShotEffect {
    DestinySpinnerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target land you control becomes an X/X Elemental creature with trample and haste until end of turn, where X is the number of enchantments you control. It's still a land.";
    }

    private DestinySpinnerEffect(DestinySpinnerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DestinySpinnerEffect copy() {
        return new DestinySpinnerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int pt = DestinySpinnerCount.instance.calculate(game, source, (Effect)this);
        game.addEffect((ContinuousEffect)new BecomesCreatureTargetEffect((Token)new CreatureToken(pt, pt, "").withSubType(SubType.ELEMENTAL).withAbility((Ability)TrampleAbility.getInstance()).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.EndOfTurn), source);
        return true;
    }
}

