/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DestroyTheEvidenceEffect
extends OneShotEffect {
    DestroyTheEvidenceEffect() {
        super(Outcome.Discard);
        this.staticText = "Its controller reveals cards from the top of their library until they reveal a land card, then puts those cards into their graveyard";
    }

    private DestroyTheEvidenceEffect(DestroyTheEvidenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public DestroyTheEvidenceEffect copy() {
        return new DestroyTheEvidenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent landPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (landPermanent != null) {
            Player player = game.getPlayer(landPermanent.getControllerId());
            if (player == null) {
                return false;
            }
            CardsImpl cards = new CardsImpl();
            for (Card card : player.getLibrary().getCards(game)) {
                if (card == null) continue;
                cards.add(card);
                if (!card.isLand(game)) continue;
                break;
            }
            player.revealCards(source, (Cards)cards, game);
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            return true;
        }
        return false;
    }
}

