/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DevourInShadowEffect
extends OneShotEffect {
    DevourInShadowEffect() {
        super(Outcome.Damage);
        this.staticText = "You lose life equal to that creature's toughness";
    }

    private DevourInShadowEffect(DevourInShadowEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevourInShadowEffect copy() {
        return new DevourInShadowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent target = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (player != null && target != null) {
            player.loseLife(target.getToughness().getValue(), game, source, false);
            return true;
        }
        return false;
    }
}

